#include "rampage.h"

#include <glrenderer.h>
#include <direct.h>
#include <material.h>
#include "heli.h"
#include "building.h"

Rampage::Rampage(HINSTANCE &hInstance) {
	system = new System(this, 1024, 668, -0.05f);
	renderer = new GLRenderer(this, hInstance);
	//renderer->initializeGraphics("Physical Rampage", 300, 300, 16);
	renderer->initializeGraphics("Physical Rampage", 1024, 768, 16);
	delay = 0;
	//compframes = 9;

	_chdir("data");

	Object *building;
	building = new Building(this);
	building->load("building.pob", 200, 0);

	player = new Monster(this, &mouse_x, &mouse_y, 2.9f, &keys['D'], &keys['A'], &keys['W'], &keys['S'], &lmb, &rmb);
	player->load("greeny.pob", 100, 0);

	Link *l;
	links.begin();
	while(l = links.get()) {
		l->reset_interactions = false;
	}
}

void Rampage::addHeli() {
	Heli *heli;
	heli = new Heli(this, player);
	heli->load("apache.pob", 900, 400);
	heli->x = 900;
	heli->y = 600;
}

void Rampage::keyDown(int key) {
	Game::keyDown(key);

	if(key == VK_ESCAPE || key == 'Q')
		quit = true;
	if(key == VK_NEXT)
		delay++;
	if(key == VK_PRIOR)
		delay--;
	if(key == 'H') {
		addHeli();
	}
	if(key == 'L') {
		Object *building;
		building = new Object(this);
		building->load("lemur.pob", 400, 200);
	}
	if(key == VK_SPACE) {
		paused = !paused;
	}
}

void Rampage::mouseMove(int x, int y) {
	Game::mouseMove(x, y);
	mouse_y -= 100;
}

void Rampage::stepFunc() {
	if(delay < 0) compframes = -delay;
	Game::stepFunc();
	for(int i = 0; i < delay; i++)
		renderer->draw();

	if((system->frame - 50) % 800 == 0) addHeli();

}

void Rampage::atomFunc(Atom *a) {
	const float fric = 0.6f;

	if(a->y < 1) {
		float dx = a->ox - a->x;
		if(dx > 0) {
			if(dx < fric)
				a->ox = a->x;
			else
				a->ox -= fric;
		}
		else {
			if(dx > -fric)
				a->ox = a->x;
			else
				a->ox += fric;
		}
	}
}

void Rampage::predraw() {
	Game::predraw();
	glColor4f(0.1f, 0.7f, 0.1f, 1.0f);

	glTranslatef(0.0f, 0.0f, 2.0f);
	glBegin(GL_QUADS);
		glVertex2f(0.0f, 0.0f);
		glVertex2f(0.0f, 100.0f);
		glVertex2f(renderer->windoww, 100.0f);
		glVertex2f(renderer->windoww, 0.0f);
	
		glColor4f(0.0f, 0.5f, 1.0f, 1.0f);

		glVertex3f(0.0f, 100.0f, -4.0f);
		glVertex3f(0.0f, renderer->windowh, -4.0f);
		glVertex3f(renderer->windoww, renderer->windowh, -4.0f);
		glVertex3f(renderer->windoww, 100.0f, -4.0f);

		if(player->arm->power <= 1.0f) {
			glColor4f(0.3f, 0.3f, 0.3f, 1.0f);

			glVertex2f(50.0f + 100.0f * player->arm->power, 50.0f);
			glVertex2f(150.0f, 50.0f);
			glVertex2f(150.0f, 60.0f);
			glVertex2f(50.0f + 100.0f * player->arm->power, 60.0f);

			glColor4f(1.0f, 0.0f, 0.0f, player->arm->power);

			glVertex2f(50.0f, 50.0f);
			glVertex2f(50.0f + 100.0f * player->arm->power, 50.0f);
			glVertex2f(50.0f + 100.0f * player->arm->power, 60.0f);
			glVertex2f(50.0f, 60.0f);
		}
		else {
			glColor4f(1.0f, 0.0f, 0.0f, player->arm->power);

			glVertex2f(50.0f, 50.0f);
			glVertex2f(150.0f, 50.0f);
			glVertex2f(150.0f, 60.0f);
			glVertex2f(50.0f, 60.0f);

			glColor4f(1.0f, 1.0f, abs((system->frame % 20) - 10) * 0.08f, player->arm->power);

			glVertex2f(150.0f, 50.0f);
			glVertex2f(150.0f + 100.0f * (player->arm->power - 1.0f), 50.0f);
			glVertex2f(150.0f + 100.0f * (player->arm->power - 1.0f), 60.0f);
			glVertex2f(150.0f, 60.0f);
		}

		glColor4f(1.0f, 0.5f, 0.5f, 1.0f);

		glVertex2f(50.0f, 30.0f);
		glVertex2f(50.0f + 100.0f * player->health, 30.0f);
		glVertex2f(50.0f + 100.0f * player->health, 40.0f);
		glVertex2f(50.0f, 40.0f);

		glColor4f(0.3f, 0.3f, 0.3f, 1.0f);

		glVertex2f(50.0f + 100.0f * player->health, 30.0f);
		glVertex2f(150.0f, 30.0f);
		glVertex2f(150.0f, 40.0f);
		glVertex2f(50.0f + 100.0f * player->health, 40.0f);
	glEnd();

	glTranslatef(0.0f, 0.0f, -2.0f);
	glTranslatef(0.0f, 100.0f, 0.0f);
}

void Rampage::draw() {	
	Object::draw();
}